/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.fabric.regions_unexplored;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.uhq_games.regions_unexplored.block.RuBlocks;
import io.github.uhq_games.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import io.github.uhq_games.regions_unexplored.world.level.block.plant.tall.ShrubBlock;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_4970;
import net.minecraft.class_7924;

public class RegionsUnexploredModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, class_2248> branchs;
    public final SimpleEntrySet<LeavesType, class_2248> shrubs;

    public RegionsUnexploredModule(String modId) {
        super(modId, "ru");
        class_2960 tab = this.modRes("main");
        this.branchs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "branch", this.getModBlock("oak_branch"), () -> WoodTypeRegistry.OAK_TYPE, w -> new BranchBlock(class_4970.class_2251.method_9630((class_4970)RuBlocks.ACACIA_BRANCH), BranchBlock.BranchType.BRANCH)).addTexture(this.modRes("block/oak_branch"))).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(this.modRes("branches"), class_7924.field_41254)).addTag(this.modRes("branches"), class_7924.field_41197)).addRecipe(this.modRes("oak_branch_from_oak_log"))).setTabKey(tab)).build();
        this.addEntry(this.branchs);
        this.shrubs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(LeavesType.class, "shrub", this.getModBlock("dark_oak_shrub"), () -> LeavesTypeRegistry.getValue((class_2960)new class_2960("dark_oak")), l -> new ShrubBlock(Utils.copyPropertySafe((class_2248)l.leaves).method_50012(class_3619.field_15971).method_50013().method_9634().method_9618().method_9626(class_2498.field_28694).method_49229(class_4970.class_2250.field_10657))).addCondition(l -> {
            boolean log = l.getWoodType() != null;
            boolean sapling = l.getItemOfThis("sapling") != null;
            return log && sapling;
        })).addTag(class_3481.field_33713, class_7924.field_41254)).addTag(this.modRes("shrubs"), class_7924.field_41254)).addTag(this.modRes("shrub_can_survive_on"), class_7924.field_41254)).addTag(this.modRes("shrubs"), class_7924.field_41197)).addRecipe(this.modRes("dark_oak_shrub"))).addRecipe(this.modRes("dark_oak_sapling_from_dark_oak_shrub"))).addTexture(EveryCompat.res("block/dark_oak_shrub_top"))).copyParentDrop().setTabKey(tab)).build();
        this.addEntry(this.shrubs);
    }

    @Override
    public void registerItemColors(ClientHelper.ItemColorEvent event) {
        super.registerItemColors(event);
        for (Map.Entry entry : this.shrubs.blocks.entrySet()) {
            LeavesType type = (LeavesType)entry.getKey();
            class_2248 block = (class_2248)entry.getValue();
            event.register((stack, tintIndex) -> {
                if (tintIndex > 0) {
                    return -1;
                }
                return event.getColor(new class_1799((class_1935)type.leaves), tintIndex);
            }, new class_1935[]{block});
        }
    }

    @Override
    public void registerBlockColors(ClientHelper.BlockColorEvent event) {
        super.registerBlockColors(event);
        for (Map.Entry entry : this.shrubs.blocks.entrySet()) {
            LeavesType type = (LeavesType)entry.getKey();
            class_2248 b = (class_2248)entry.getValue();
            event.register((blockState, tintGetter, pos, index) -> event.getColor(type.leaves.method_9564(), tintGetter, pos, index), new class_2248[]{b});
        }
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, class_3300 manager) {
        super.addDynamicServerResources(handler, manager);
        this.branchs.blocks.forEach((wood, block) -> {
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((class_2960)this.modRes("branches_can_survive_on"));
            tagBuilder.add(Utils.getID((class_2248)wood.log));
            ((DynamicDataPack)handler.dynamicPack).addTag(tagBuilder, class_7924.field_41254);
            TagUtility.createAndAddCustomTags(new class_2960("planks"), handler, wood.planks);
            TagUtility.createAndAddCustomTags(new class_2960("c:planks"), handler, wood.planks);
        });
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, class_3300 manager) {
        super.addDynamicClientResources(handler, manager);
        try (TextureImage branch_side = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("item/oak_branch_side"));
             TextureImage branch_top = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("item/oak_branch_top"));
             TextureImage branch_block = TextureImage.open((class_3300)manager, (class_2960)this.modRes("block/oak_branch"));){
            this.branchs.blocks.forEach((wood, block) -> {
                try (TextureImage logSide_texture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                     TextureImage logTop_texture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                    class_2960 resLocITEM = EveryCompat.res("item/" + this.shortenedId() + "/" + wood.getAppendableId() + "_branch");
                    class_2960 resLocBLOCK = EveryCompat.res("block/" + this.shortenedId() + "/" + wood.getAppendableId() + "_branch");
                    Respriter respriterSIDE = Respriter.of((TextureImage)branch_side);
                    Respriter respriterTOP = Respriter.of((TextureImage)branch_top);
                    Respriter respriterBlock = Respriter.of((TextureImage)branch_block);
                    TextureImage recoloredITEM = respriterSIDE.recolorWithAnimationOf(logSide_texture);
                    TextureImage recoloredTOP = respriterTOP.recolorWithAnimationOf(logTop_texture);
                    recoloredITEM.applyOverlay(new TextureImage[]{recoloredTOP});
                    TextureImage recoloredBLOCK = respriterBlock.recolorWithAnimationOf(logSide_texture);
                    ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(resLocBLOCK, recoloredBLOCK);
                    ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(resLocITEM, recoloredITEM);
                }
                catch (IOException e) {
                    handler.getLogger().error("Failed to get Log Texture for {} : {}", block, (Object)e);
                }
            });
        }
        catch (IOException e) {
            handler.getLogger().error("Failed to get Branch Item Texture for ", (Throwable)e);
        }
        try (TextureImage shrubMiddle = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/regions_unexplored/dark_oak_shrub_middle"));
             TextureImage shrubBottom = TextureImage.open((class_3300)manager, (class_2960)this.modRes("block/dark_oak_shrub_bottom"));){
            this.shrubs.blocks.forEach((leavesType, block) -> {
                String shrubPath = this.shortenedId() + "/" + leavesType.getAppendableId() + "_shrub";
                String crossModel = "{\n    \"parent\": \"minecraft:block/cross\",\n    \"render_type\": \"cutout\",\n    \"textures\": {\n        \"particle\": \"[shrub_top]\",\n        \"cross_tint\": \"[shrub_top]\",\n        \"cross\": \"[shrub_middle]\"\n    },\n    \"elements\": [\n        {   \"from\": [ 0.8, 0, 8 ],\n            \"to\": [ 15.2, 16, 8 ],\n            \"rotation\": { \"origin\": [ 8, 8, 8 ], \"axis\": \"y\", \"angle\": 45, \"rescale\": true },\n            \"shade\": false,\n            \"faces\": {\n                \"north\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross\" },\n                \"south\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross\" }\n            }\n        },\n        {   \"from\": [ 8, 0, 0.8 ],\n            \"to\": [ 8, 16, 15.2 ],\n            \"rotation\": { \"origin\": [ 8, 8, 8 ], \"axis\": \"y\", \"angle\": 45, \"rescale\": true },\n            \"shade\": false,\n            \"faces\": {\n                \"west\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross\" },\n                \"east\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross\" }\n            }\n        },\n        {   \"from\": [ 0.8, 0, 8 ],\n            \"to\": [ 15.2, 16, 8 ],\n            \"rotation\": { \"origin\": [ 8, 8, 8 ], \"axis\": \"y\", \"angle\": 45, \"rescale\": true },\n            \"shade\": false,\n            \"faces\": {\n                \"north\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross_tint\", \"tintindex\": 0 },\n                \"south\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross_tint\", \"tintindex\": 0 }\n            }\n        },\n        {   \"from\": [ 8, 0, 0.8 ],\n            \"to\": [ 8, 16, 15.2 ],\n            \"rotation\": { \"origin\": [ 8, 8, 8 ], \"axis\": \"y\", \"angle\": 45, \"rescale\": true },\n            \"shade\": false,\n            \"faces\": {\n                \"west\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross_tint\", \"tintindex\": 0 },\n                \"east\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross_tint\", \"tintindex\": 0 }\n            }\n        }\n    ]\n}\n";
                String blockID = "everycomp:block/" + shrubPath;
                String newModel = crossModel.replace("[shrub_middle]", blockID + "_middle").replace("[shrub_top]", blockID + "_top");
                ((DynamicTexturePack)handler.dynamicPack).addBytes(EveryCompat.res(shrubPath), newModel.getBytes(), ResType.BLOCK_MODELS);
                class_2960 itemPath = ResType.ITEM_MODELS.getPath(EveryCompat.res(shrubPath));
                try (InputStream modelItemStream = ((class_3298)manager.method_14486(itemPath).orElseThrow(FileNotFoundException::new)).method_14482();){
                    JsonObject modelItem = RPUtils.deserializeJson((InputStream)modelItemStream);
                    modelItem.getAsJsonObject("textures").addProperty("layer0", blockID + "_top");
                    modelItem.getAsJsonObject("textures").addProperty("layer1", blockID + "_middle");
                    ((DynamicTexturePack)handler.dynamicPack).addJson(EveryCompat.res(shrubPath), (JsonElement)modelItem, ResType.ITEM_MODELS);
                }
                catch (IOException e) {
                    handler.getLogger().error("Failed to open the item model file via {} : {}", (Object)itemPath, (Object)e);
                }
                try (TextureImage logTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)leavesType.getWoodType().log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));){
                    Respriter respriterBottom = Respriter.of((TextureImage)shrubBottom);
                    Respriter respriterMiddle = Respriter.of((TextureImage)shrubMiddle);
                    TextureImage recoloredMiddle = respriterMiddle.recolorWithAnimationOf(logTexture);
                    TextureImage recoloredBottom = respriterBottom.recolorWithAnimationOf(logTexture);
                    String resLoc = "block/" + shrubPath;
                    ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(EveryCompat.res(resLoc + "_middle"), recoloredMiddle);
                    ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(EveryCompat.res(resLoc + "_bottom"), recoloredBottom);
                }
                catch (IOException e) {
                    handler.getLogger().error("Failed to get texture for {} : {}", (Object)block.toString(), (Object)e);
                }
            });
        }
        catch (IOException e) {
            handler.getLogger().error("Failed to open textures for: ", (Throwable)e);
        }
    }
}

